<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Destino extends Model 
{

    protected $table = 'destino';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function articulo_destino()
    {
        return $this->hasMany('App\Models\ArticuloDestino');
    }

    public function tipo()
    {
        return $this->belongsTo('App\Models\TipoDestino');
    }

    public function remito()
    {
        return $this->hasMany('App\Models\Remito');
    }

}